##
## Join UCDP External Support data with SVAC data
##

ExternalSupport.df <- read.csv(file="Daten/UCDP External Support Dataset/159834_1external_support_compact_dataset_1.00_20110325-1.csv", na.strings=c(-99, NULL, ""), sep=";")
ExternalSupport.df <- subset(ExternalSupport.df, subset = ExternalSupport.df$ywp_year > 1988 & ExternalSupport.df$ywp_year < 2010,
                             select = c(ywp_year, actorID, conflictID, 
                                                            external_exists, external_type__X, 
                                                            external_type__L, external_type__Y, 
                                                            external_type__W, external_type__M, 
                                                            external_type__T, external_type__., 
                                                            external_type__I, external_type__O, 
                                                            external_type__U))
ExternalSupport.df <- rename(ExternalSupport.df, c("ywp_year" = "year", "actorID" = "actorid", "conflictID" = "conflictid"))
ExternalSupport.df <- ExternalSupport.df[!duplicated(ExternalSupport.df),]
ExternalSupport.df <- aggregate(ExternalSupport.df, by = list(year=ExternalSupport.df$year, # if several entries per conflict: keep highest value!
                                                              actorid=ExternalSupport.df$actorid,
                                                              conflictid=ExternalSupport.df$conflictid), FUN=max, na.rm=T)

Master <- join(Master, ExternalSupport.df, type="left", by=c("conflictid", "actorid", "year"), match="all")

Master$external_exists[is.infinite(Master$external_exists) | is.nan(Master$external_exists)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_exists[Master$external_exists==-1] <- NA # define (-1) as Missing Value

Master$external_type__X[is.infinite(Master$external_type__X) | is.nan(Master$external_type__X)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__X[Master$external_type__X==-1] <- NA # define (-1) as Missing Value

Master$external_type__L[is.infinite(Master$external_type__L) | is.nan(Master$external_type__L)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__L[Master$external_type__L==-1] <- NA # define (-1) as Missing Value

Master$external_type__Y[is.infinite(Master$external_type__Y) | is.nan(Master$external_type__Y)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__Y[Master$external_type__Y==-1] <- NA # define (-1) as Missing Value

Master$external_type__W[is.infinite(Master$external_type__W) | is.nan(Master$external_type__W)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__W[Master$external_type__W==-1] <- NA # define (-1) as Missing Value

Master$external_type__M[is.infinite(Master$external_type__M) | is.nan(Master$external_type__M)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__M[Master$external_type__M==-1] <- NA # define (-1) as Missing Value

Master$external_type__T[is.infinite(Master$external_type__T) | is.nan(Master$external_type__T)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__T[Master$external_type__T==-1] <- NA # define (-1) as Missing Value

Master$external_type__.[is.infinite(Master$external_type__.) | is.nan(Master$external_type__.)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__.[Master$external_type__.==-1] <- NA # define (-1) as Missing Value

Master$external_type__I[is.infinite(Master$external_type__I) | is.nan(Master$external_type__I)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__I[Master$external_type__I==-1] <- NA # define (-1) as Missing Value

Master$external_type__O[is.infinite(Master$external_type__O) | is.nan(Master$external_type__O)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__O[Master$external_type__O==-1] <- NA # define (-1) as Missing Value

Master$external_type__U[is.infinite(Master$external_type__U) | is.nan(Master$external_type__U)] <- 0 # replace -Inf & NA with 0 (assumption: no entry = no support)
Master$external_type__U[Master$external_type__U==-1] <- NA # define (-1) as Missing Value

rm(ExternalSupport.df)
